
// --- Listeners

window.addEventListener('DOMContentLoaded', function() {
    addQuoteStyles();
});

// --- Quotes

function addQuoteStyles() {
    //-- CSS styles for quotes
    var styles = document.createElement("style");
    styles.textContent = ".dl-mail-quote {display: none;}\
    .dl-mail-quote .dl-mail-quote {display: block;}";
    
    document.head.appendChild(styles);
    
    // this check is not working as intended. So we do that weird trick of .insertBefore
    if (document.querySelector(".dl-mail-quote")) {
        hasHiddenQuotedText(true);
    }
}

function showQuotes() {
    if (document.querySelector(".dl-mail-quote")) {
        document.querySelector(".dl-mail-quote").style.display = "block";
        resizeWindow();
        hasHiddenQuotedText(false);
    }
}

function hideQuotes() {
    if (document.querySelector(".dl-mail-quote")) {
        document.querySelector(".dl-mail-quote").style.display = "none";
        resizeWindow();
        hasHiddenQuotedText(true);
    }
}

function hasHiddenQuotedText(hidden) {
    window.webkit.messageHandlers.quotedText.postMessage({hiddenQuotedText: hidden});
}

function setIsExpanded(flag) {
    document.body.style.backgroundColor = flag ? 'var(--expanded-background-color)' : '';
}
