# Session Renewal

LLMs have context window limits. When conversation history gets too long, you can't add more. Session renewal manages this automatically.

## The Problem

```
╔════════════════════════════════════════════════════════╗
║  Conversation History                                  ║
╠════════════════════════════════════════════════════════╣
║  [0] System instructions                               ║
║  [1] User: "Hello"                                     ║
║  [2] Assistant: "Hi!"                                  ║
║  [3] User: "Tell me about..."                          ║
║  [4] Assistant: "..."                                  ║
║  ...                                                   ║
║  [998] User: "And also..."                             ║
║  [999] Assistant: "..."                                ║
║  [1000] ❌ CONTEXT WINDOW FULL                         ║
╚════════════════════════════════════════════════════════╝

Without renewal: ❌ Error thrown
With renewal: ✅ History managed automatically
```

## Renewal Policy Components

```
SessionRenewalPolicy
  ├─ strategy: SessionRenewalStrategy
  │    └─ How to preserve history
  └─ autoRenewOnContextLimit: Bool
       └─ Automatic vs manual
```

## The Four Strategies

### `.basic`

```
╔════════════════════════════════════════════════════════╗
║  Keep: First entry + Last entry only                   ║
╠════════════════════════════════════════════════════════╣
║  Before:                                               ║
║  [0] Instructions                                      ║
║  [1] User: "Hello"                                     ║
║  [2] Assistant: "Hi"                                   ║
║  [3] User: "How are you?"                              ║
║  [4] Assistant: "Good"                                 ║
║  [5] User: "Thanks" ← Context full                     ║
║                                                        ║
║  After:                                                ║
║  [0] Instructions ← Kept                               ║
║  [1] User: "Thanks" ← Kept                             ║
╚════════════════════════════════════════════════════════╝

✅ Simplest
✅ Fastest
❌ Loses most context
```

### `.custom(entryIndices:)`

```
╔════════════════════════════════════════════════════════╗
║  Keep: Specified indices                               ║
╠════════════════════════════════════════════════════════╣
║  .custom(entryIndices: [0, 2, 5])                      ║
║                                                        ║
║  Before:                                               ║
║  [0] Instructions                                      ║
║  [1] User: "Context A"                                 ║
║  [2] User: "Important!"                                ║
║  [3] Assistant: "..."                                  ║
║  [4] User: "..."                                       ║
║  [5] User: "Critical context"                          ║
║  [6] User: "Current question"                          ║
║                                                        ║
║  After:                                                ║
║  [0] Instructions ← Kept                               ║
║  [2] User: "Important!" ← Kept                         ║
║  [5] User: "Critical context" ← Kept                   ║
╚════════════════════════════════════════════════════════╝

✅ Precise control
✅ Preserve key entries
❌ Requires knowing indices
```

### `.lastN(count:)`

```
╔════════════════════════════════════════════════════════╗
║  Keep: Instructions + Last N entries                   ║
╠════════════════════════════════════════════════════════╣
║  .lastN(count: 3)                                      ║
║                                                        ║
║  Before:                                               ║
║  [0] Instructions                                      ║
║  [1] User: "Old context"                               ║
║  [2] Assistant: "..."                                  ║
║  [3] User: "..."                                       ║
║  [4] Assistant: "..."                                  ║
║  [5] User: "Recent A"                                  ║
║  [6] Assistant: "Response A"                           ║
║  [7] User: "Recent B"                                  ║
║  [8] User: "Current"                                   ║
║                                                        ║
║  After:                                                ║
║  [0] Instructions ← Kept                               ║
║  [6] Assistant: "Response A" ← Last 3                  ║
║  [7] User: "Recent B"                                  ║
║  [8] User: "Current"                                   ║
╚════════════════════════════════════════════════════════╝

✅ Recent context preserved
✅ Predictable
✅ Good for conversations
```

### `.summarize`

```
╔════════════════════════════════════════════════════════╗
║  Keep: Instructions + Summary + Last entry             ║
╠════════════════════════════════════════════════════════╣
║  Before:                                               ║
║  [0] Instructions                                      ║
║  [1] User: "Tell me about dogs"                        ║
║  [2] Assistant: "Dogs are loyal..."                    ║
║  [3] User: "What about cats?"                          ║
║  [4] Assistant: "Cats are independent..."              ║
║  [5] User: "Which is better?"                          ║
║  [6] Assistant: "It depends..."                        ║
║  [7] User: "I prefer dogs"                             ║
║                                                        ║
║  After:                                                ║
║  [0] Instructions ← Kept                               ║
║  [1] Summary: "User discussed dogs vs cats.            ║
║      User prefers dogs." ← AI-generated                ║
║  [2] User: "I prefer dogs" ← Last entry                ║
╚════════════════════════════════════════════════════════╝

✅ Best context preservation
✅ Natural continuation
❌ Slower (extra LLM call)
❌ Requires capable backend
```

## Auto-Renewal Flow

```
┌─────────────────────────────────┐
│ User sends prompt               │
└─────────────────────────────────┘
         ↓
┌─────────────────────────────────┐
│ Add to history                  │
│ Check context size              │
└─────────────────────────────────┘
         ↓
    Within limit?
         ↓
    ┌────┴────┐
   YES       NO
    │         │
    │         ▼
    │    Auto-renewal?
    │         ↓
    │    ┌────┴────┐
    │   YES       NO
    │    │         │
    │    │         ▼
    │    │    Throw error
    │    │
    │    ▼
    │ Apply strategy
    │    ↓
    │ ┌─────────────┐
    │ │ .basic      │→ Keep first + last
    │ │ .custom     │→ Keep specified
    │ │ .lastN      │→ Keep last N
    │ │ .summarize  │→ Generate summary
    │ └─────────────┘
    │    ↓
    │ Reduced history
    │    │
    ▼    ▼
Generate response
```

## Disabled Auto-Renewal

```
SessionRenewalPolicy.disabled
         ↓
┌─────────────────────────────────┐
│ autoRenewOnContextLimit: false  │
└─────────────────────────────────┘
         ↓
Context full?
         ↓
┌─────────────────────────────────┐
│ Throws error                    │
│ User must handle manually       │
└─────────────────────────────────┘
```

## Strategy Comparison

```
╔═══════════╦═══════╦════════════╦══════════╦══════════════╗
║ Strategy  ║ Speed ║ Context    ║ Complex  ║ Use Case     ║
╠═══════════╬═══════╬════════════╬══════════╬══════════════╣
║ .basic    ║ ████  ║ █░░░░░░░░░ ║ ░░░░░░░░ ║ Quick chats  ║
║ .custom   ║ ███░  ║ ████░░░░░░ ║ ██░░░░░░ ║ Specific     ║
║           ║       ║            ║          ║ needs        ║
║ .lastN    ║ ███░  ║ ███░░░░░░░ ║ █░░░░░░░ ║ Conversations║
║ .summarize║ █░░░  ║ ████████░░ ║ ████░░░░ ║ Quality      ║
║           ║       ║            ║          ║ critical     ║
╚═══════════╩═══════╩════════════╩══════════╩══════════════╝
```

## Decision Guide

```
╔════════════════════════════╦═══════════════════════════╗
║ Scenario                   ║ Recommendation            ║
╠════════════════════════════╬═══════════════════════════╣
║ Short interactions         ║ .disabled or .basic       ║
║ Ongoing conversations      ║ .lastEntries(15-20)       ║
║ Long sessions              ║ .summarize                ║
║ Specific context critical  ║ .custom(preserving: [...])║
║ Quality > speed            ║ .summarize                ║
║ Speed > quality            ║ .basic or .lastN          ║
╚════════════════════════════╩═══════════════════════════╝
```
