# Session Configuration

## The Story

Every session needs instructions. "You're a helpful assistant." "Extract data accurately." "Be concise." But that's not all—you also want examples, tool definitions, schema policies, and renewal strategies. **SessionConfiguration is the control panel that bundles everything together.**

## Visual Overview

```
┏━━━━━━━━━━━━━━━━━━━━━━━━━┓
┃ SessionConfiguration    ┃
┣━━━━━━━━━━━━━━━━━━━━━━━━━┫
┃                         ┃
┃ ┌─────────────────────┐ ┃
┃ │ instructions        │ ┃  "You are..."
┃ └─────────────────────┘ ┃
┃                         ┃
┃ ┌─────────────────────┐ ┃
┃ │ exampleResponse     │ ┃  "Output: {...}"
┃ └─────────────────────┘ ┃
┃                         ┃
┃ ┌─────────────────────┐ ┃
┃ │ schemaPolicy        │ ┃  When to include schemas
┃ └─────────────────────┘ ┃
┃                         ┃
┃ ┌─────────────────────┐ ┃
┃ │ renewalPolicy       │ ┃  How to handle context limits
┃ └─────────────────────┘ ┃
┃                         ┃
┃ ┌─────────────────────┐ ┃
┃ │ tools               │ ┃  Available tools
┃ └─────────────────────┘ ┃
┃                         ┃
┗━━━━━━━━━━━━━━━━━━━━━━━━━┛
```

## Creation Flow

```
You build config:
┌──────────────────────────────┐
│ SessionConfiguration(        │
│   instructions:              │
│     "You are a data          │
│      extraction assistant",  │
│                              │
│   exampleResponse:           │
│     "Result: {...}",         │
│                              │
│   schemaPolicy:              │
│     SchemaPolicy(            │
│       handling:              │
│         .intelligent         │
│     ),                       │
│                              │
│   renewalPolicy:             │
│     .summarize,              │
│                              │
│   tools: [                   │
│     WeatherTool(),           │
│     CalculatorTool()         │
│   ]                          │
│ )                            │
└──────────────────────────────┘
         ↓
Pass to engine:
┌──────────────────────────────┐
│ engine.createSession(        │
│   configuration: config      │
│ )                            │
└──────────────────────────────┘
         ↓
Backend receives it:
┌──────────────────────────────┐
│ Backend translates to        │
│ native format:               │
│                              │
│ - instructions → system      │
│   prompt                     │
│ - tools → tool schemas       │
│ - policies → behavior flags  │
└──────────────────────────────┘
         ↓
Session created:
┌──────────────────────────────┐
│ InferenceSession             │
│ (config stored immutably)    │
└──────────────────────────────┘
```

## Instructions

The model's personality and rules.

```
┌──────────────────────────────┐
│ instructions:                │
│   "You are a helpful         │
│    assistant that extracts   │
│    company information       │
│    from text. Be accurate    │
│    and concise."             │
└──────────────────────────────┘
         ↓
Becomes system message:
┌──────────────────────────────┐
│ [SYSTEM]                     │
│ You are a helpful assistant  │
│ that extracts company...     │
└──────────────────────────────┘
         ↓
Model behavior shaped by this
```

## Example Response

Show the model what you want.

```
┌──────────────────────────────┐
│ exampleResponse:             │
│   "Output: Company 'Acme     │
│    Corp' with 500 employees" │
└──────────────────────────────┘
         ↓
Combined with instructions:
┌──────────────────────────────┐
│ You are a helpful assistant  │
│ that extracts...             │
│                              │
│ Example response:            │
│ Output: Company 'Acme Corp'  │
│ with 500 employees           │
└──────────────────────────────┘
         ↓
Model learns output format
```

## Schema Policy

Controls when schemas are included (see schema-system.md).

```
┌──────────────────────────────┐
│ schemaPolicy:                │
│   SchemaPolicy(              │
│     handling:                │
│       .intelligent           │
│   )                          │
└──────────────────────────────┘
         ↓
String call → no schema
Structured call → schema included
```

**Default:** `.alwaysInclude`

## Renewal Policy

Handles context window exhaustion (see session-renewal.md).

```
┌──────────────────────────────┐
│ renewalPolicy:               │
│   .lastEntries(20)           │
└──────────────────────────────┘
         ↓
Context limit hit:
┌──────────────────────────────┐
│ Keep instructions            │
│ Keep last 20 entries         │
│ Discard older entries        │
└──────────────────────────────┘
         ↓
Session renewed, continues
```

**Default:** `.basic` (keep first + last only)

## Tools

Functions the model can call (see Tool Calling doc).

```
┌──────────────────────────────┐
│ tools: [                     │
│   WeatherTool(),             │
│   CalculatorTool()           │
│ ]                            │
└──────────────────────────────┘
         ↓
Backend generates tool schemas:
┌──────────────────────────────┐
│ Tool 1: "get_weather"        │
│   - city: string             │
│   - units: string            │
│                              │
│ Tool 2: "calculate"          │
│   - expression: string       │
└──────────────────────────────┘
         ↓
Model can invoke these during generation
```

**Default:** Empty array (no tools)

## What Gets Used When

```
┌────────────────────────┐
│ Session Creation       │
├────────────────────────┤
│ ✅ instructions        │
│ ✅ exampleResponse     │
│ ✅ schemaPolicy        │
│ ✅ renewalPolicy       │
│ ✅ tools               │
└────────────────────────┘

┌────────────────────────┐
│ Every generate() call  │
├────────────────────────┤
│ ✅ instructions (used) │
│ ✅ schemaPolicy (checked)│
│ ✅ tools (available)   │
└────────────────────────┘

┌────────────────────────┐
│ Context limit hit      │
├────────────────────────┤
│ ✅ renewalPolicy (applied)│
└────────────────────────┘
```

## The Flow Through System

```
You create config
         ↓
Pass to InferenceEngine
         ↓
Engine passes to Backend
         ↓
Backend creates session with config
         ↓
Session stores config (immutable)
         ↓
Every operation uses config:
  - generate() → uses instructions, schema policy
  - stream() → same
  - Tool calls → uses tools
  - Context overflow → uses renewal policy
         ↓
Config shapes all behavior
```

## Relationship to Other Systems

```
SessionConfiguration
         │
         ├─→ Schema System
         │   (via schemaPolicy)
         │
         ├─→ Session Renewal
         │   (via renewalPolicy)
         │
         ├─→ Tool Calling
         │   (via tools array)
         │
         └─→ Structured Types
             (schemas generated for Generable types)
```

## Decision Guide

```
╔══════════════════════════════╦═══════════════════════════╗
║ Include                      ║ When                      ║
╠══════════════════════════════╬═══════════════════════════╣
║ instructions                 ║ Need behavior control     ║
║ exampleResponse              ║ Clarify output format     ║
║ schemaPolicy                 ║ Optimize token usage      ║
║ renewalPolicy                ║ Long conversations        ║
║ tools                        ║ LLM needs external data   ║
╚══════════════════════════════╩═══════════════════════════╝
```
