# Inference Presets

Different backends have different knobs:
- Temperature
- Top-k
- Top-p  
- Max tokens
- Frequency penalty
- ...

You don't want to learn all of that. You just want "fast" or "creative."

## The Three Presets

### `.fastest`

```
Characteristics:
┌────────────────────────┐
│ ⚡️ Maximum speed       │
│ 🎯 Deterministic       │
│ 📏 Short responses     │
│ 🚫 No randomness       │
└────────────────────────┘

Use for:
• Quick facts
• Data extraction
• Structured output
• Caching scenarios
```

### `.balanced`

```
Characteristics:
┌────────────────────────┐
│ ⚖️  Speed + Quality    │
│ 💬 Natural language    │
│ 📊 Moderate length     │
│ 🎲 Slight variation    │
└────────────────────────┘

Use for:
• Conversations
• Q&A
• Summaries
• General use
```

### `.creative`

```
Characteristics:
┌────────────────────────┐
│ 🎨 High randomness     │
│ 📝 Longer responses    │
│ 🌈 Variety             │
│ 💡 Exploratory         │
└────────────────────────┘

Use for:
• Creative writing
• Brainstorming
• Stories
• Multiple perspectives
```

## Backend Translation

```
InferencePreset → Backend Parameters (for FoundationModels)

┌─────────────┬──────────────────────────────────┬──────────────┬─────────────────────┐
│ Preset      │ Sampling                         │ Temperature  │ Max Response Tokens │
├─────────────┼──────────────────────────────────┼──────────────┼─────────────────────┤
│ .fastest    │ Greedy                           │ 0.0          │ 100                 │
│ .balanced   │ random(top: 50)                  │ 0.5          │ 500                 │
│ .creative   │ random(probabilityThreshold: 0.9)│ 1.0          │ None                │
└─────────────┴──────────────────────────────────┴──────────────┴─────────────────────┘

Note: Exact mapping varies by backend
```

## Comparison

```
Metric          .fastest    .balanced   .creative
─────────────────────────────────────────────────
Speed           ████        ███         ██
Determinism     ████        ██          ░
Creativity      ░           ███         ████
Length          ██          ███         ████
Cacheability    ████        ██          ░

████ = High    ░ = Low
```

## Decision Guide

```
╔═══════════════════════════╦═══════════════════════════╗
║ Use                       ║ When                      ║
╠═══════════════════════════╬═══════════════════════════╣
║ .fastest                  ║ Data extraction           ║
║                           ║ Structured output         ║
║                           ║ Quick facts               ║
║                           ║ Need determinism          ║
║                           ║ Caching results           ║
╠═══════════════════════════╬═══════════════════════════╣
║ .balanced                 ║ Conversations             ║
║                           ║ Q&A                       ║
║                           ║ Summaries                 ║
║                           ║ General purpose           ║
╠═══════════════════════════╬═══════════════════════════╣
║ .creative                 ║ Writing                   ║
║                           ║ Brainstorming             ║
║                           ║ Story generation          ║
║                           ║ Exploring ideas           ║
╠═══════════════════════════╬═══════════════════════════╣
║ nil                       ║ Trust backend defaults    ║
╚═══════════════════════════╩═══════════════════════════╝
```
