<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:sfa="http://developer.apple.com/namespaces/sfa" xmlns:sf="http://developer.apple.com/namespaces/sf" xmlns:ls="http://developer.apple.com/namespaces/ls" xmlns:sl="http://developer.apple.com/namespaces/sl">  
           
<xsl:param name="replacementsPath"></xsl:param>
         
      <xsl:template name="replaceStrings">
        <xsl:param name="inputText" />
        <xsl:param name="search" />
       
	   <xsl:choose>
		<xsl:when test="count($search/find)">
        <xsl:variable name="replaced_text">
            <xsl:call-template name="replaceString">
              <xsl:with-param name="sourceText" select="$inputText" />
              <xsl:with-param name="findText" select="$search[1]/find" />
              <xsl:with-param name="replaceText" select="$search[1]/replace" />
            </xsl:call-template>
        </xsl:variable>
        <xsl:choose>
            <xsl:when test="$search[2]">
              <xsl:call-template name="replaceStrings">
                  <xsl:with-param name="inputText" select="$replaced_text" />
                  <xsl:with-param name="search" select="$search[position() > 1]" />
              </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="$replaced_text" />
            </xsl:otherwise>
        </xsl:choose>
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select="$inputText"/>
		</xsl:otherwise>
		</xsl:choose>
      </xsl:template>
     
     
      <xsl:template name="replaceString">
        <xsl:param name="sourceText"/>
        <xsl:param name="findText"/>
        <xsl:param name="replaceText"/>
        <xsl:choose>         
            <xsl:when test="contains($sourceText,$findText)"> 
              <xsl:value-of select="concat(substring-before($sourceText,$findText),$replaceText)"/>
              <xsl:call-template name="replaceString">
                  <xsl:with-param name="sourceText" select="substring-after($sourceText,$findText)"/>
                  <xsl:with-param name="findText" select="$findText"/>
                  <xsl:with-param name="replaceText" select="$replaceText"/>
              </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="$sourceText"/>
            </xsl:otherwise>
        </xsl:choose>
      </xsl:template>

<xsl:template match="*|@*|node()|processing-instruction()|comment()">
	<xsl:copy>
	        <xsl:apply-templates select="*|@*|node()|processing-instruction()|comment()" />
	</xsl:copy>
</xsl:template>

<xsl:template match="text()">
  <xsl:call-template name="replaceStrings">
  <xsl:with-param name="inputText" select="."/>
  <xsl:with-param name="search" select="document($replacementsPath)/SearchAndReplace/search"/> 
	</xsl:call-template>
</xsl:template>

<xsl:template match="@href">
	<xsl:variable name="replaced">
		<xsl:call-template name="replaceStrings">
			<xsl:with-param name="inputText">
				<xsl:call-template name="decode">
					<xsl:with-param name="encoded" select="."/>
				</xsl:call-template>
			</xsl:with-param>
			<xsl:with-param name="search" select="document($replacementsPath)/SearchAndReplace/search"/> 
		</xsl:call-template>
	</xsl:variable>
	<xsl:attribute name="href">
		<xsl:call-template name="url-encode">
			<xsl:with-param name="str" select="$replaced"/>
		</xsl:call-template>
	</xsl:attribute>
</xsl:template>

<xsl:template match="@sfa:*|@sf:*|@ls:workspace-name">
	<xsl:attribute name="{name()}" namespace="{namespace-uri()}">
		<xsl:call-template name="replaceStrings">
			<xsl:with-param name="inputText" select="."/>
			<xsl:with-param name="search" select="document($replacementsPath)/SearchAndReplace/search"/> 
		</xsl:call-template>
	</xsl:attribute>
</xsl:template>

<xsl:template match="/">
	<xsl:apply-templates />
</xsl:template>
  
    <xsl:variable name="ascii"> !"#$%&amp;'()*+,-./0123456789:;&lt;=&gt;?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`abcdefghijklmnopqrstuvwxyz{|}~</xsl:variable>
  <xsl:variable name="latin1">&#160;&#161;&#162;&#163;&#164;&#165;&#166;&#167;&#168;&#169;&#170;&#171;&#172;&#173;&#174;&#175;&#176;&#177;&#178;&#179;&#180;&#181;&#182;&#183;&#184;&#185;&#186;&#187;&#188;&#189;&#190;&#191;&#192;&#193;&#194;&#195;&#196;&#197;&#198;&#199;&#200;&#201;&#202;&#203;&#204;&#205;&#206;&#207;&#208;&#209;&#210;&#211;&#212;&#213;&#214;&#215;&#216;&#217;&#218;&#219;&#220;&#221;&#222;&#223;&#224;&#225;&#226;&#227;&#228;&#229;&#230;&#231;&#232;&#233;&#234;&#235;&#236;&#237;&#238;&#239;&#240;&#241;&#242;&#243;&#244;&#245;&#246;&#247;&#248;&#249;&#250;&#251;&#252;&#253;&#254;&#255;</xsl:variable>

  <!-- Characters that usually don't need to be escaped -->
  <xsl:variable name="safe">!'()*-/:=@?.0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ_abcdefghijklmnopqrstuvwxyz~</xsl:variable>

  <xsl:variable name="hex" >0123456789ABCDEF</xsl:variable>

  <xsl:template name="url-encode">
    <xsl:param name="str"/>   
    <xsl:if test="$str">
      <xsl:variable name="first-char" select="substring($str,1,1)"/>
      <xsl:choose>
        <xsl:when test="contains($safe,$first-char)">
          <xsl:value-of select="$first-char"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:variable name="codepoint">
            <xsl:choose>
              <xsl:when test="contains($ascii,$first-char)">
                <xsl:value-of select="string-length(substring-before($ascii,$first-char)) + 32"/>
              </xsl:when>
              <xsl:when test="contains($latin1,$first-char)">
                <xsl:value-of select="string-length(substring-before($latin1,$first-char)) + 160"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:message terminate="no">Warning: string contains a character that is out of range! Substituting "?".</xsl:message>
                <xsl:text>63</xsl:text>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:variable>
        <xsl:variable name="hex-digit1" select="substring($hex,floor($codepoint div 16) + 1,1)"/>
        <xsl:variable name="hex-digit2" select="substring($hex,$codepoint mod 16 + 1,1)"/>
        <xsl:value-of select="concat('%',$hex-digit1,$hex-digit2)"/>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:if test="string-length($str) &gt; 1">
        <xsl:call-template name="url-encode">
          <xsl:with-param name="str" select="substring($str,2)"/>
        </xsl:call-template>
      </xsl:if>
    </xsl:if>
  </xsl:template>


  <xsl:template name="decode">
    <xsl:param name="encoded"/>
    <xsl:choose>
      <xsl:when test="contains($encoded,'%')">
        <xsl:value-of select="substring-before($encoded,'%')"/>
        <xsl:variable name="hexpair" select="translate(substring(substring-after($encoded,'%'),1,2),'abcdef','ABCDEF')"/>
        <xsl:variable name="decimal" select="(string-length(substring-before($hex,substring($hexpair,1,1))))*16 + string-length(substring-before($hex,substring($hexpair,2,1)))"/>
        <xsl:choose>
          <xsl:when test="$decimal &lt; 127 and $decimal &gt; 31">
            <xsl:value-of select="substring($ascii,$decimal - 31,1)"/>
          </xsl:when>
          <xsl:when test="$decimal &gt; 159">
            <xsl:value-of select="substring($latin1,$decimal - 159,1)"/>
          </xsl:when>
          <xsl:otherwise>?</xsl:otherwise>
        </xsl:choose>
        <xsl:call-template name="decode">
          <xsl:with-param name="encoded" select="substring(substring-after($encoded,'%'),3)"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$encoded"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
</xsl:stylesheet>
